/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.StatusMonitorConfigBean;
import com.ibm.hwmca.ui.bonsai.event.EventQueue;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitor;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.status.event.StatusMonitorPropertyEvent;
import com.ibm.hwmca.ui.bonsai.status.event.StatusMonitorPropertyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatusMonitorManager {
    private static final String TRACEMASK_T = "XBUISTST";
    private static final String TRACEMASK_F = "XBUISTSF";
    private static final String TRACEMASK_D = "XBUISTSD";
    private static StatusMonitorManager statusManager;
    private static Object lock;
    private static List configBeans;
    private List statusMonitors;
    private EventQueue eventQueue;
    private Set statusListeners;
    private GlobalPropertyListener systemListener;

    public StatusMonitorManager(UserObject userObj) {
        Trace.trace(TRACEMASK_T, "<--> StatusMonitorManager(" + userObj + ")");
        if (configBeans == null) {
            throw new IllegalStateException("StatusMonitorManager.init() must be called prior to construction!");
        }
        this.statusMonitors = new ArrayList(configBeans.size());
        StatusMonitorConfigBean bean = null;
        StatusMonitor monitor = null;
        Iterator i = configBeans.iterator();
        while (i.hasNext()) {
            bean = (StatusMonitorConfigBean)i.next();
            try {
                monitor = (StatusMonitor)Class.forName(bean.getClassName()).newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
            monitor.init(userObj, bean.getKey(), bean.getParameters(), bean.getUIInfo());
            this.statusMonitors.add(monitor);
        }
        this.eventQueue = new EventQueue("SMM." + userObj.getHMCSession().getDisplayableSessionId() + ".EventQueue");
        this.statusListeners = new HashSet();
        this.systemListener = new GlobalPropertyListener();
        this.systemListener.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List configBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> StatusMonitorManager.init(" + configBeans + ")");
        Object object = lock;
        synchronized (object) {
            if (StatusMonitorManager.configBeans == null) {
                StatusMonitorManager.configBeans = configBeans;
                StatusMonitor monitor = null;
                StatusMonitorConfigBean bean = null;
                Iterator i = configBeans.iterator();
                while (i.hasNext()) {
                    bean = (StatusMonitorConfigBean)i.next();
                    try {
                        monitor = (StatusMonitor)Class.forName(bean.getClassName()).newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    monitor.validateParameters(bean.getParameters());
                }
            }
        }
    }

    public List getOrderedKeyList() {
        ArrayList<String> keys = new ArrayList<String>(this.statusMonitors.size());
        Iterator i = this.statusMonitors.iterator();
        while (i.hasNext()) {
            keys.add(((StatusMonitor)i.next()).getKey());
        }
        return keys;
    }

    public Map getStatusMonitorBeans() {
        HashMap<String, StatusMonitorBean> beans = new HashMap<String, StatusMonitorBean>(this.statusMonitors.size() + 1, 1.0f);
        StatusMonitor monitor = null;
        Iterator i = this.statusMonitors.iterator();
        while (i.hasNext()) {
            monitor = (StatusMonitor)i.next();
            beans.put(monitor.getKey(), monitor.getStatusMonitorBean());
        }
        return beans;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusMonitorPropertyListener(StatusMonitorPropertyListener listener) {
        Set set = this.statusListeners;
        synchronized (set) {
            this.statusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getStatusMonitorPropertyListeners() {
        Set set = this.statusListeners;
        synchronized (set) {
            return new HashSet(this.statusListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusMonitorPropertyListener(StatusMonitorPropertyListener listener) {
        Set set = this.statusListeners;
        synchronized (set) {
            this.statusListeners.remove(listener);
        }
    }

    public void destroy() {
        this.systemListener.deregister();
    }

    static {
        lock = new Object();
    }

    private class GlobalPropertyListener
    implements PropertyChangeListener {
        private GlobalPropertyListener() {
        }

        private synchronized void register() {
            UIObjectsWriter.getUIObjectsWriter().addPropertyChangeListener(this);
        }

        private synchronized void deregister() {
            UIObjectsWriter.getUIObjectsWriter().removePropertyChangeListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent event) {
            Set listeners = StatusMonitorManager.this.getStatusMonitorPropertyListeners();
            StatusMonitor monitor = null;
            Iterator i = StatusMonitorManager.this.statusMonitors.iterator();
            while (i.hasNext()) {
                monitor = (StatusMonitor)i.next();
                if (!monitor.updateData()) continue;
                StatusMonitorManager.this.eventQueue.enqueue(new StatusMonitorPropertyEvent(monitor, listeners));
            }
        }
    }
}

